//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Nil-Coalescing Operator
//:
//: We can supply a default value for when an optional is `nil`.
//:
//: In this scenario we can use the nil-coalescing operator *(sounds complicated but it's simple 😂)* to provide a default value. The nil-coalescing operator is written with two question marks *(`??`)* after the variable name.
//:
//: -------------------
//:


// the value on the right is used when the optional is nil
print(nil ?? "👉 Some default value to use 👈")
// << 🔵 Run Point

let myOptional: String? = nil
print(myOptional ?? "👉 Some default value to use 👈")


//:
//: -------------------
//:
//: ## Task:
//:
//: Rewrite the code above (in the space below) but this time use optional binding with an if-then-else statement to print for both scenarios; when there is a value and when there is no value.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// Tip: ⚡️ Don't forget to use The Swift Cheatsheet when ever you forget the structure of the code (the syntax)!


//:
//: -------------------
//:
//: ## Task:
//:
//: Let's think of a real-life example.
//:
//: Let's create a users profile utilising some business logic for the display name. Our requirements will be to prioritise displaying a nickname first and if one doesn't exist then fallback to their full name.
//:
//: Finish the code below using the nil-coalescing operator.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// custom type using a struct
struct Profile {
    
    // stored properties
    let firstName: String
    let lastName: String
    let nickname: String?
    let age: Int
    
    // computed properties
    var fullName: String {
        return firstName + " " + lastName
    }
    var displayName: String { 
        // TODO: Apply our business logic here
        // provide the nickname, otherwise the full name
        return
    }
}

// instantiate an instance of our custom struct
let profile = Profile(firstName: "John", lastName: "Appleseed", nickname: nil, age: 38)

// use dot notation to access the display name computed property
print("Welcome, \(profile.displayName)")


//:
//: -------------------
//:
//: ## Task:
//:
//: Go back to the code above. Remove the `return` keyword from the two computed properties. Swift allows us to omit (means "leave out") the `return` keyword when we are using a one-line closure.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:
